/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.lang;

import edu.princeton.toy.lang.TException;
import edu.princeton.toy.lang.TExceptionType;

public interface TExceptionHandler {
    public static final TExceptionHandler PROMISCUOUS_EXCEPTION_HANDLER = new TExceptionHandler(){

        @Override
        public void raise(TExceptionType type) throws TException {
            if (type == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public boolean getWillThrow(int index) {
            if (index < 0 || index >= TExceptionType.TYPES.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return false;
        }

        @Override
        public boolean getWillThrow(TExceptionType type) {
            if (type == null) {
                throw new NullPointerException();
            }
            return false;
        }
    };
    public static final TExceptionHandler PRUDISH_EXCEPTION_HANDLER = new TExceptionHandler(){

        @Override
        public void raise(TExceptionType type) throws TException {
            throw new TException(type);
        }

        @Override
        public boolean getWillThrow(int index) {
            if (index < 0 || index >= TExceptionType.TYPES.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return true;
        }

        @Override
        public boolean getWillThrow(TExceptionType type) {
            if (type == null) {
                throw new NullPointerException();
            }
            return true;
        }
    };

    public void raise(TExceptionType var1) throws TException;

    public boolean getWillThrow(int var1);

    public boolean getWillThrow(TExceptionType var1);
}

